<?php
/********************************************************************************
 MachForm
  
 Copyright 2007-2016 Appnitro Software. This code cannot be redistributed without
 permission from http://www.appnitro.com/
 
 More info at: http://www.appnitro.com/
 ********************************************************************************/
	require('config.php');
	require('lib/db-session-handler.php');
	require('includes/init.php');
	require('includes/db-core.php');
	require('includes/helper-functions.php');
	require('includes/check-session.php');

	require('includes/filter-functions.php');

	$_POST = json_decode(file_get_contents('php://input'), true);
	
	$form_id 	            = (int) trim($_POST['form_id'] ?? '0');
    $entries_rows_per_page 	= abs ((int) trim($_POST['entries_rows_per_page'] ?? '0'));
	$user_id 	            = (int) $_SESSION['mf_user_id'];
	$csrf_token             = trim($_POST['csrf_token'] ?? '');

	//validate CSRF token
	mf_verify_csrf_token($csrf_token);

	$incomplete_entries = isset($_POST['incomplete_entries']) ? (int) $_POST['incomplete_entries'] : false; //if this is operation targetted to incomplete entries, this will contain '1'
	if(empty($incomplete_entries)){
		$incomplete_entries = 0;
	}

	if(empty($form_id)){
		die("This file can't be opened directly.");
	}

    if(empty($entries_rows_per_page)){
        $entries_rows_per_page = 15; //set the default
    }

	$dbh = mf_connect_db();
	
	//check if ap_entries_preferences already have the record or not
	//if not, insert a new record first
	$query = "select count(*) total_row from ".MF_TABLE_PREFIX."entries_preferences where form_id=? and `user_id`=?";
		
	$params = array($form_id,$_SESSION['mf_user_id']);
	$sth = mf_do_query($query,$params,$dbh);
	$row = mf_do_fetch_result($sth);
	
	$total_row = $row['total_row'];

	if(empty($total_row)){ 
		$query = "insert into ".MF_TABLE_PREFIX."entries_preferences(`entries_sort_by`,`form_id`,`user_id`,`entries_rows_per_page`,`entries_incomplete_rows_per_page`) values(?,?,?,?,?)";
		$params = array('id-desc',$form_id,$_SESSION['mf_user_id'],15,15);
		mf_do_query($query,$params,$dbh);
	}

	//update existing record within ap_entries_preferences
	if(empty($incomplete_entries)){
		$query = "update ".MF_TABLE_PREFIX."entries_preferences set entries_rows_per_page=? where form_id=? and user_id=?";
	}else{
		$query = "update ".MF_TABLE_PREFIX."entries_preferences set entries_incomplete_rows_per_page=? where form_id=? and user_id=?";
	}
	
    $params = array($entries_rows_per_page,$form_id,$user_id);
	mf_do_query($query,$params,$dbh);

	
	$response_data = new stdClass();
	$response_data->status    	= "ok";
	$response_data->form_id 	= $form_id;
	
	$response_json = json_encode($response_data);
	
	echo $response_json;
?>